CREATE OR REPLACE FUNCTION tplanterm.abk_term(
    _ab_ix integer,
    _start_date date,
    _forward boolean default true,
    _autoInPlantaf boolean DEFAULT false,
    _use_new_termination boolean DEFAULT false,
    _pack_abk boolean default false
)
RETURNS DATE
AS $$

  DECLARE
    _work_date TIMESTAMP;

    _einzelteil_record RECORD;
    _baugruppen_record RECORD;

    _do_date DATE;
    _tmp_date DATE;

  BEGIN

    _work_date := _start_date;
    _do_date   := _start_date;

    --es müssen alle untergeordneten ABK eingeplant werden
    -- DELETE FROM ab2_wkstplan WHERE a2w_a2_id IN (SELECT * FROM tplanterm.get_all_child_abk(:ab_ix));
    PERFORM tplanterm.abk_austerm( _ab_ix );


    IF ( _use_new_termination ) THEN
      PERFORM tabk.abk__ab2_wkstplan__reset_ksv( _ab_ix );
    END IF;

    IF _forward THEN

        -- Einzelteile vorwärts
        FOR _einzelteil_record IN
        SELECT ab_ix FROM abk
        WHERE
            ab_parentabk IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ) )
        AND NOT EXISTS( SELECT true FROM abk abchild WHERE abchild.ab_parentabk = abk.ab_ix )
        ORDER BY ab_ix DESC
        LOOP

            IF ( _use_new_termination ) THEN
              _work_date := max( __slotenddate )
                            FROM scheduling.resource_timeline__abk_ab2__termination(
                              _einzelteil_record.ab_ix,
                              _do_date,
                              _start_date + interval '3 year',
                              true,
                              'forward',
                              NULL,
                              true,
                              _pack_abk
                            );
            ELSE
              _work_date := tplanterm.abk_abg_term( _einzelteil_record.ab_ix, _do_date, _forward );
            END IF;


            IF ( current_user = 'root' ) THEN
              RAISE NOTICE 'workdate for abk % = %', _einzelteil_record.ab_ix, _work_date;
            END IF;

            --abbrechen wenn es zu weit geht, warum auch immer
            IF ( _work_date::date > _start_date + 400 ) THEN
              RAISE EXCEPTION 'abk: % termini stopped on date, more than 400 days duration %', _einzelteil_record.ab_ix, _work_date;
            END IF;

        END LOOP;


        -- Baugruppen vorwärts
        FOR _baugruppen_record IN
        SELECT ab_ix FROM abk
        WHERE
            ab_parentabk IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ) )
        AND EXISTS( SELECT true FROM abk abchild WHERE abchild.ab_parentabk = abk.ab_ix )
        ORDER BY ab_ix DESC
        LOOP

            --wir ermitteln den spätesten Endezeitpunkt der untergeordneten Einzelteile
            _tmp_date  := _work_date;
            _work_date := MAX(COALESCE(a2_et, ab_et))
                          FROM abk
                          LEFT OUTER JOIN ab2 ON ab_ix = a2_ab_ix
                          WHERE
                              ab_ix IN ( SELECT ab_ix FROM abk WHERE ab_parentabk = _baugruppen_record.ab_ix )
                          AND NOT a2_ende;

            _work_date := COALESCE(_work_date,_tmp_date);

            IF ( current_user = 'root' ) THEN
              RAISE NOTICE 'workdate for abk % = %', _baugruppen_record.ab_ix, _work_date;
            END IF;

            --bei Baugruppen die nur aus Normteilen bestehen gehts sonst ned da keine untergeordneten ABK
            _work_date := COALESCE( _work_date, _do_date );

            --nun planen wir uns selbst ab diesem Termin ein.
            IF ( _use_new_termination ) THEN
              _work_date := max( __slotenddate )
                            FROM tabk.resource_timeline__abk_ab2__termination(
                              _baugruppen_record.ab_ix,
                              _work_date,
                              _start_date + interval '3 year',
                              true,
                              'forward',
                              NULL,
                              true,
                              _pack_abk
                            );
            ELSE
              _work_date := tplanterm.abk_abg_term( _baugruppen_record.ab_ix, _work_date, _forward );
            END IF;


            --abbrechen wenn es zu weit geht, warum auch immer
            If ( _work_date::date > _start_date + 400 ) THEN
                    RAISE EXCEPTION 'abk: % termini stopped on date, more than 400 days duration %', _baugruppen_record.ab_ix, _work_date;
            END IF;

        END LOOP;


        --Hauptbaugruppe vorwärts
        _tmp_date   := _work_date;
        _work_date  := MAX(COALESCE(a2_et, ab_et))
                       FROM ab2
                       JOIN abk ON ab_ix = a2_ab_ix
                       WHERE
                            a2_ab_ix IN (SELECT * FROM tplanterm.get_all_child_abk(_ab_ix))
                        AND NOT a2_ende;

        _work_date  := COALESCE(_work_date,_tmp_date);

        -- COALESCE UM DATUM FALLS ES NUR HAUPTBAUTEIL GIBT; SIND UNTERTERMINE IMMER NULL
        -- nun planen wir uns selbst ab diesem Termin ein.
        IF ( _use_new_termination ) THEN
          _work_date := max( __slotenddate )
                        FROM tabk.resource_timeline__abk_ab2__termination(
                          _ab_ix,
                          COALESCE( _work_date, _do_date ),
                          _start_date + interval '3 year',
                          true,
                          'forward',
                          NULL,
                          true,
                          _pack_abk
                        );
        ELSE
          _work_date := tplanterm.abk_abg_term( _ab_ix, COALESCE(_work_date, _do_date), _forward );
        END IF;

    ELSE

        -- beim rückwärtsterminieren mit den Hauptbaugruppe anfangen
        IF ( _use_new_termination ) THEN
          _work_date := min( __slotstartdate )
                        FROM tabk.resource_timeline__abk_ab2__termination(
                          _ab_ix,
                          _start_date - interval '3 year',
                          _work_date,
                          true,
                          'backwards',
                          NULL,
                          true,
                          _pack_abk
                        );
        ELSE
          _work_date := tplanterm.abk_abg_term( _ab_ix, _work_date, _forward );
        END IF;

        -- Baugruppen rückwärts
        FOR _baugruppen_record IN
        SELECT ab_ix, ab_parentabk
        FROM abk
        WHERE
            ab_parentabk IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ) )
        AND EXISTS( SELECT true FROM abk abchild WHERE abchild.ab_parentabk = abk.ab_ix )
        ORDER BY ab_ix
        LOOP

            --wir ermitteln den Anfangszeitpunkt des Parents
            _tmp_date   := _work_date;
            _work_date  := MIN( COALESCE(a2_at, ab_at) )
                           FROM abk
                           LEFT OUTER JOIN ab2 ON ab_ix = a2_ab_ix AND NOT a2_ende
                           WHERE ab_ix = _baugruppen_record.ab_parentabk;

            _work_date  := COALESCE( _work_date,_tmp_date);

            IF ( current_user = 'root' ) THEN
              RAISE NOTICE 'workdate for abk % = %', _baugruppen_record.ab_ix, _work_date;
            END IF;

            --nun planen wir uns selbst ab diesem Termin ein.
            IF ( _use_new_termination ) THEN
              _work_date := min( __slotstartdate )
                            FROM tabk.resource_timeline__abk_ab2__termination(
                              _baugruppen_record.ab_ix,
                              _start_date - interval '3 year',
                              _work_date,
                              true,
                              'backwards',
                              NULL,
                              true,
                              _pack_abk
                            );
            ELSE
              _work_date := tplanterm.abk_abg_term( _baugruppen_record.ab_ix, _work_date, _forward );
            END IF;


            --abbrechen wenn es zu weit geht, warum auch immer
            If ( _work_date::date < _start_date - 400 ) THEN
              RAISE EXCEPTION 'abk: % termini stopped on date, more than 400 days duration %', _baugruppen_record.ab_ix, _work_date;
            END IF;

        END LOOP;

        --wir merken uns den Endtermin
        _do_date := _work_date;

        -- Einzelteile rückwärts
        FOR _einzelteil_record IN
        SELECT ab_ix, ab_parentabk
        FROM abk
        WHERE
            ab_parentabk IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ) )
        AND NOT EXISTS( SELECT true FROM abk abchild WHERE abchild.ab_parentabk = abk.ab_ix )
        ORDER BY ab_ix
        LOOP

            --wir ermitteln den Anfangszeitpunkt des Parents
            _tmp_date  := _work_date;
            _work_date := MIN(COALESCE(a2_at, ab_at))
                          FROM abk
                          LEFT OUTER JOIN ab2 ON ab_ix=a2_ab_ix AND NOT a2_ende
                          WHERE ab_ix = _einzelteil_record.ab_parentabk;

            _work_date := COALESCE(_work_date,_tmp_date);

            IF ( current_user = 'root' ) THEN
              RAISE NOTICE 'workdate for abk % = %', _einzelteil_record.ab_ix, _work_date;
            END IF;

            --nun planen wir uns selbst ab diesem Termin ein.
            IF ( _use_new_termination ) THEN
              _work_date := min( __slotstartdate )
                            FROM tabk.resource_timeline__abk_ab2__termination(
                              _einzelteil_record.ab_ix,
                              _start_date - interval '3 year',
                              _work_date,
                              true,
                              'backwards',
                              NULL,
                              true,
                              _pack_abk
                            );
            ELSE
              _work_date := tplanterm.abk_abg_term( _einzelteil_record.ab_ix, _work_date, _forward );
            END IF;

            --abbrechen wenn es zu weit geht, warum auch immer
            If ( _work_date::date < _start_date - 400 ) THEN
              RAISE EXCEPTION 'abk: % termini stopped on date, more than 400 days duration %', _einzelteil_record.ab_ix, _work_date;
            END IF;

        END LOOP;

    END IF;

    -- eintragen anfang und Ende in ABK durch abk_abg_term, dies aktualisiert die Termine in AUFTG und LDSDOK!
    -- neu terminiert automatisch in plantafel
    IF ( _autoInPlantaf OR TSystem.Settings__GetBool('CheckWkstPlanTermAutoPlan') ) THEN

      UPDATE abk
      SET ab_inplantaf=TRUE
      WHERE
           ab_ix IN ( SELECT * FROM tplanterm.get_all_child_abk( _ab_ix ) )
       AND NOT ab_inplantaf;

    END IF;


    RETURN _work_date;

END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tplanterm.abk_austerm(IN _abk_ix integer, IN _resource_id_main_fix__Reset boolean DEFAULT false ) RETURNS VOID AS $$
  BEGIN
    -- Flag setzen, damit der AB2-Trigger nicht versucht, die Termine in die ABK zu schreiben.
    PERFORM TSystem.Settings__Set('tplanterm.abk_abg_term.inTerminierung', '1');

    -- Die Übergeordneten nicht entterminieren. Beim einzelnen Terminieren eines Einzelteiles haben sonst die Kopfartikel alle keinen Termin mehr.
    UPDATE abk SET ab_at = NULL, ab_et = NULL, ab_auftgi_kdatum = NULL, ab_inplantaf = false WHERE ab_ix IN ( _abk_ix ) AND NOT ab_buch AND ab_at IS NOT NULL AND ab_et IS NOT NULL;
    UPDATE ab2 SET a2_at = NULL, a2_et = NULL, a2_interm = false WHERE a2_ab_ix IN ( _abk_ix ) AND NOT a2_buch AND a2_at IS NOT NULL AND a2_et IS NOT NULL;
    UPDATE ldsdok SET ld_term = IFTHEN(ld_interncreate, NULL, ld_term), ld_terml = NULL WHERE ld_abk IN ( _abk_ix ) AND NOT ld_done;
    UPDATE auftg SET ag_kdatum = NULL, ag_ldatum = NULL WHERE ag_parentabk IN ( _abk_ix ) AND NOT ag_done AND ag_astat = 'I';
    UPDATE auftg SET ag_kdatum = NULL, ag_ldatum = NULL WHERE ag_mainabk   IN ( _abk_ix ) AND NOT ag_done AND ag_astat = 'I';

    UPDATE ab2_wkstplan SET a2w_planweek = NULL, a2w_endweek = NULL, a2w_pat = NULL, a2w_pet = NULL
     WHERE a2w_a2_id IN (SELECT a2_id FROM ab2 WHERE a2_ab_ix = _abk_ix AND NOT a2_buch) AND a2w_planweek IS NOT NULL;

    IF _resource_id_main_fix__Reset THEN
        -- OHNE FUNKTION alte Planung! Müßte UPDATE ab2_wkstplan SET a2w_ks = null??? usw. Ging seit Jahren nicht!
    END IF;

    -- Flag setzen, damit der AB2-Trigger nicht versucht, die Termine in die ABK zu schreiben.
    PERFORM TSystem.Settings__Set('tplanterm.abk_abg_term.inTerminierung', '0');

  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tabk.abk__ab2_wkstplan__reset_ksv( _ab_ix int ) RETURNS void AS $$

DECLARE
  _r record;
  r record;
  planpool bool;
  arbpnum int;
  _shorthand varchar;

BEGIN

  FOR _r in select * from ab2 where a2_ab_ix = _ab_ix LOOP

      IF NOT _r.a2_ende THEN

        SELECT ks_planpool INTO planpool FROM ksv WHERE ks_abt = _r.a2_ks;
        --
        SELECT ks_babz, ks_babz1, ks_babz2, ks_babz3, ks_babz4, ks_babz5, ks_babz6, ks_babz7, ks_babz8, ks_babz9 INTO r FROM ksv WHERE ks_abt= _r.a2_ks;
        CASE WHEN r.ks_babz = _r.a2_ksap THEN arbpnum:= 1;
             WHEN r.ks_babz1= _r.a2_ksap THEN arbpnum:= 2;
             WHEN r.ks_babz2= _r.a2_ksap THEN arbpnum:= 3;
             WHEN r.ks_babz3= _r.a2_ksap THEN arbpnum:= 4;
             WHEN r.ks_babz4= _r.a2_ksap THEN arbpnum:= 5;
             WHEN r.ks_babz5= _r.a2_ksap THEN arbpnum:= 6;
             WHEN r.ks_babz6= _r.a2_ksap THEN arbpnum:= 7;
             WHEN r.ks_babz7= _r.a2_ksap THEN arbpnum:= 8;
             WHEN r.ks_babz8= _r.a2_ksap THEN arbpnum:= 9;
             WHEN r.ks_babz9= _r.a2_ksap THEN arbpnum:=10;
             ELSE arbpnum:=0;
        END CASE;
        --
        IF planpool THEN --noch nicht aufgenommen, soll in den Pool

            IF  _r.a2_ksap IS NULL THEN --kein vordefinierter Arbeitsplatz in Arbeitsgang
                UPDATE ab2_wkstplan SET a2w_ks = _r.a2_ks||' |0',  a2w_oks = _r.a2_ks where a2w_a2_id = _r.a2_id;
            END IF;

            IF arbpnum>1 THEN
                UPDATE ab2_wkstplan SET a2w_ks = _r.a2_ks||' /'||arbpnum,  a2w_oks = _r.a2_ks where a2w_a2_id = _r.a2_id;
            ELSIF arbpnum=1 THEN--Stammarbeitplatz
                UPDATE ab2_wkstplan SET a2w_ks = _r.a2_ks,   a2w_oks = _r.a2_ks where a2w_a2_id = _r.a2_id;
            END IF;

        ELSE--kein Planpool

            IF arbpnum>1 THEN--Arbeitsplatz ermittelt
                UPDATE ab2_wkstplan SET a2w_ks = _r.a2_ks||' /'||arbpnum,  a2w_oks = _r.a2_ks where a2w_a2_id = _r.a2_id;
            ELSE--Stammarbeitplatz
                UPDATE ab2_wkstplan SET a2w_ks = _r.a2_ks,  a2w_oks = _r.a2_ks where a2w_a2_id = _r.a2_id;
            END IF;
        END IF;

    END IF;

  END LOOP;

END $$ language plpgsql;


-- Funktion löst ksb_ks_shorthand in Kostenstelle und Arbeitsplatz auf
  CREATE OR REPLACE FUNCTION scheduling.resource__translate__ksvba__shorthand__to__ks_abt__ks_ba_bz(
      IN  _shorthand character varying,
      OUT ks_abt     character varying,
      OUT ks_ba_bz   character varying
      )
      RETURNS record    
      AS $$  
         SELECT ksb_ks_abt     AS ks_abt,
                ksb_ks_ba_babz AS ks_ba_bz
           FROM ksvba
          WHERE ksb_ks_shorthand = _shorthand;
     $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE  

